// Generated by CoffeeScript 1.7.1
(function() {
  var CrashReporter, binding, crashRepoter, fs, os, path, spawn;

  binding = process.atomBinding('crash_reporter');

  fs = require('fs');

  os = require('os');

  path = require('path');

  spawn = require('child_process').spawn;

  CrashReporter = (function() {
    function CrashReporter() {}

    CrashReporter.prototype.start = function(options) {
      var args, autoSubmit, companyName, env, extra, ignoreSystemCrashHandler, start, submitUrl;
      if (options == null) {
        options = {};
      }
      this.productName = options.productName, companyName = options.companyName, submitUrl = options.submitUrl, autoSubmit = options.autoSubmit, ignoreSystemCrashHandler = options.ignoreSystemCrashHandler, extra = options.extra;
      if (this.productName == null) {
        this.productName = 'Atom-Shell';
      }
      if (companyName == null) {
        companyName = 'GitHub, Inc';
      }
      if (submitUrl == null) {
        submitUrl = 'http://54.249.141.255:1127/post';
      }
      if (autoSubmit == null) {
        autoSubmit = true;
      }
      if (ignoreSystemCrashHandler == null) {
        ignoreSystemCrashHandler = false;
      }
      if (extra == null) {
        extra = {};
      }
      if (extra._productName == null) {
        extra._productName = this.productName;
      }
      if (extra._companyName == null) {
        extra._companyName = companyName;
      }
      if (extra._version == null) {
        extra._version = process.type === 'browser' ? require('app').getVersion() : require('remote').require('app').getVersion();
      }
      start = (function(_this) {
        return function() {
          return binding.start(_this.productName, companyName, submitUrl, autoSubmit, ignoreSystemCrashHandler, extra);
        };
      })(this);
      if (process.platform === 'win32') {
        args = ["--reporter-url=" + submitUrl, "--application-name=" + this.productName, "--v=1"];
        env = {
          ATOM_SHELL_INTERNAL_CRASH_SERVICE: 1
        };
        spawn(process.execPath, args, {
          env: env,
          detached: true
        });
        return start();
      } else {
        return start();
      }
    };

    CrashReporter.prototype.getLastCrashReport = function() {
      var e, id, log, reports, time, tmpdir, _ref;
      tmpdir = process.platform === 'win32' ? os.tmpdir() : '/tmp';
      log = path.join(tmpdir, "" + this.productName + " Crashes", 'uploads.log');
      try {
        reports = String(fs.readFileSync(log)).split('\n');
        if (!(reports.length > 1)) {
          return null;
        }
        _ref = reports[reports.length - 2].split(','), time = _ref[0], id = _ref[1];
        return {
          date: new Date(parseInt(time) * 1000),
          id: id
        };
      } catch (_error) {
        e = _error;
        return null;
      }
    };

    return CrashReporter;

  })();

  crashRepoter = new CrashReporter;

  module.exports = crashRepoter;

}).call(this);
